package kom.itbeankit.nw.ethernet;

import java.awt.*;
import kom.itbeankit.nw.ethernet.Host;
import symantec.itools.awt.VerticalSlider;
import symantec.itools.awt.BorderPanel;
import kom.itbeankit.nw.ethernet.BusSegment;
import kom.itbeankit.common.vcr.ClkEvent;
import kom.itbeankit.common.vcr.ClkListener;
import kom.itbeankit.common.message.MessageListener;
import kom.itbeankit.common.message.MessageEvent;

import kom.itbeankit.common.vcr.ControlButtonPanel;
public class Ethernet extends java.awt.Container implements EthernetInterface,
                                                            ClkListener,MessageListener
{
    protected AlgorithmInterface algorithm;
    protected boolean usePadField;
    protected int numOfHosts = 8;
	private java.util.Vector messageListeners=new java.util.Vector();
    protected int scenario = SCENARIO_NONE;

    public void setEnabled(boolean b){
        super.setEnabled(b);
        host1.setEnabled(b);
        host2.setEnabled(b);
        host3.setEnabled(b);
        host4.setEnabled(b);
        host5.setEnabled(b);
        host6.setEnabled(b);
        host7.setEnabled(b);
        host8.setEnabled(b);
    }
    
    public void doScenario(ClkEvent e){
        switch(scenario){
            case SCENARIO_NONE:
                scenarioNone(e);
            break;
            case SCENARIO_NORMAL:
                scenarioNormal(e);
            break;
            case SCENARIO_COLLISION:
                scenarioCollision(e);
            break;
            case SCENARIO_BROADCAST:
                scenarioBroadcast(e);
            break;
            case SCENARIO_SHORT_FRAME:
                scenarioShortFrame(e);
            break;
            default:
        }
    }
    
    void scenarioNone(ClkEvent e)
    {
        if(e.isRisingEdge())
            showEfficiency();
        busSegment1.clkReceived(e);
        host1.clkReceived(e);
        host2.clkReceived(e);
        if(numOfHosts>2){
            host3.clkReceived(e);
            host4.clkReceived(e);
            busSegment2.clkReceived(e);
        }
        if(numOfHosts>4){
            host5.clkReceived(e);
            host6.clkReceived(e);
            busSegment3.clkReceived(e);
        }
        if(numOfHosts>6){
            busSegment4.clkReceived(e);
            host7.clkReceived(e);
            host8.clkReceived(e);
        }
    }
    
    void scenarioNormal(ClkEvent e)
    {
        setNumOfHosts(8);
    //        reset();
        msg("scenario normal operation","\n"+
            "  in this scenario host5 sends"+"\n"+
            "   a frame to host8");
		host5.setFrameSize(FRAME_SIZE_NORMAL);
		host5.setAutoRepeat(false);
		host5.setDestinationHost(8);
        scenario = SCENARIO_NONE;
    //    scenarioNone(e);
    }
    
    void scenarioCollision(ClkEvent e)
    {
        setNumOfHosts(8);
     //   reset();
        msg("scenario collision","\n"+
            "   in this scenario host2 and"+"\n"+
            "   host7 send frames at the same"+"\n"+
            "   time to host5 and host1");
		host2.setFrameSize(FRAME_SIZE_NORMAL);
		host2.setAutoRepeat(false);
		host7.setFrameSize(FRAME_SIZE_NORMAL);
		host7.setAutoRepeat(false);
		host2.setDestinationHost(5);
		host7.setDestinationHost(1);
        scenario = SCENARIO_NONE;
   //     scenarioNone(e);
        
    }
    
    void scenarioBroadcast(ClkEvent e)
    {
        setNumOfHosts(8);
   //     reset();
        msg("scenario broadcast","\n"+
            "  in this scenario host4 sends"+"\n"+
            "   a frame to all other hosts");
		host4.setFrameSize(FRAME_SIZE_NORMAL);
		host4.setAutoRepeat(false);
		host4.setDestinationHost(HOST_ADDRESS_BROADCAST);
        scenario = SCENARIO_NONE;
   //     scenarioNone(e);
        
    }
    
    void scenarioShortFrame(ClkEvent e)
    {
        setNumOfHosts(8);
  //      reset();
        msg("scenario short frame","\n"+
            "   in this scenario host1 and"+"\n"+
            "   host8 send frames at the same"+"\n"+
            "   time to host5 and host2. host1"+"\n"+
            "   sends a too short frame and cannot"+"\n"+
            "   detect that a collision happens"+"\n"+
            "   try this scenario with and without"+"\n"+
            "   use of pad field to see the difference");
		host1.setFrameSize(FRAME_SIZE_SHORT);
		host1.setAutoRepeat(false);
		host8.setFrameSize(FRAME_SIZE_NORMAL);
		host8.setAutoRepeat(false);
		host1.setDestinationHost(5);
		host8.setDestinationHost(2);
        scenario = SCENARIO_NONE;
 //       scenarioNone(e);
    }
       
    public void setScenario(int scenario){
        this.scenario = scenario;
    }
    
    public int getScenario(){
        return scenario;
    }
    
    void msg(String subject, String message){
        deliverMessage(new MessageEvent(    this,
                                            MessageEvent.DISPLAY_TYPE_TEXTAREA,
                                            MessageEvent.MSG_TYPE_INFO,
                                            subject, message));
    }

	public void deliverMessage(MessageEvent me){
	    MessageEvent event = new MessageEvent(this,me);
        for(int i=0; i<messageListeners.size();i++){
            MessageListener ml = (MessageListener)messageListeners.elementAt(i);
            ml.deliverMessage(event);
        }
	}
    public synchronized void addMessageListener(MessageListener lis)
    {
        messageListeners.addElement(lis);
    }

    public synchronized void removeMessageListener(MessageListener lis)
    {
        messageListeners.removeElement(lis);
    }

    public void setNumOfHosts(int num)
    {
        switch(num){
            case 2:
                numOfHosts = 2;
                set2ndPairVisible(false);
                set3rdPairVisible(false);
                set4thPairVisible(false);
            break;
            case 4:
                numOfHosts = 4;
                set2ndPairVisible(true);
                set3rdPairVisible(false);
                set4thPairVisible(false);
            break;
            case 6:
                numOfHosts = 6;
                set2ndPairVisible(true);
                set3rdPairVisible(true);
                set4thPairVisible(false);
            break;
            case 8:
                numOfHosts = 8;
                set2ndPairVisible(true);
                set3rdPairVisible(true);
                set4thPairVisible(true);
            break;
            default:
        }
    }

    void set2ndPairVisible(boolean b){
       host3.setVisible(b);
       host4.setVisible(b);
       busSegment2.setVisible(b);
       if(!b){
           host3.reset();
           host4.reset();
           busSegment2.reset();
       }
    }
    void set3rdPairVisible(boolean b){
       host5.setVisible(b);
       host6.setVisible(b);
       busSegment3.setVisible(b);
       if(!b){
           host5.reset();
           host6.reset();
           busSegment3.reset();
       }
    }
    void set4thPairVisible(boolean b){
       host7.setVisible(b);
       host8.setVisible(b);
       busSegment4.setVisible(b);
       if(!b){
           host7.reset();
           host8.reset();
           busSegment4.reset();
       }
    }

    public int getNumOfHosts()
    {
        return numOfHosts;
    }


    public void setAlgorithm(String algorithmName)
    {
        this.algorithm = algorithm;
        host1.setAlgorithm(algorithmName);
        host2.setAlgorithm(algorithmName);
        host3.setAlgorithm(algorithmName);
        host4.setAlgorithm(algorithmName);
        host5.setAlgorithm(algorithmName);
        host6.setAlgorithm(algorithmName);
        host7.setAlgorithm(algorithmName);
        host8.setAlgorithm(algorithmName);
    }

    public AlgorithmInterface getAlgorithm()
    {
        return this.algorithm;
    }

	public void setUsePadField(boolean usePadField)
	{
		this.usePadField = usePadField;
        host1.setUsePadField(usePadField);
        host2.setUsePadField(usePadField);
        host3.setUsePadField(usePadField);
        host4.setUsePadField(usePadField);
        host5.setUsePadField(usePadField);
        host6.setUsePadField(usePadField);
        host7.setUsePadField(usePadField);
        host8.setUsePadField(usePadField);
	}

	public boolean isUsePadField()
	{
		return this.usePadField;
	}

	public Ethernet()
	{
		//{{INIT_CONTROLS
		setLayout(new BorderLayout(0,0));
		setSize(500,240);
		csmaLabel = new java.awt.Label(" Carrier Sense Multiple Access Protocols");
		csmaLabel.setBounds(0,0,500,31);
		csmaLabel.setFont(new Font("DialogInput", Font.BOLD, 20));
		add("North", csmaLabel);
		ethernetPanel = new java.awt.Panel();
		ethernetPanel.setLayout(null);
		ethernetPanel.setBounds(0,31,400,209);
		add("West", ethernetPanel);
		hostTopPanel = new java.awt.Panel();
		hostTopPanel.setLayout(null);
		hostTopPanel.setBounds(10,10,400,74);
		ethernetPanel.add(hostTopPanel);
		host1 = new kom.itbeankit.nw.ethernet.Host();
		host1.setLayout(null);
		host1.setBounds(0,0,80,74);
		hostTopPanel.add(host1);
		host1.setCursor(new Cursor(Cursor.HAND_CURSOR));
		host3 = new kom.itbeankit.nw.ethernet.Host();
		host3.setID(3);
		host3.setLayout(null);
		host3.setBounds(90,0,80,74);
		hostTopPanel.add(host3);
		host3.setCursor(new Cursor(Cursor.HAND_CURSOR));
		host5 = new kom.itbeankit.nw.ethernet.Host();
		host5.setID(5);
		host5.setLayout(null);
		host5.setBounds(180,0,80,74);
		hostTopPanel.add(host5);
		host5.setCursor(new Cursor(Cursor.HAND_CURSOR));
		host7 = new kom.itbeankit.nw.ethernet.Host();
		host7.setID(7);
		host7.setLayout(null);
		host7.setBounds(270,0,80,74);
		hostTopPanel.add(host7);
		host7.setCursor(new Cursor(Cursor.HAND_CURSOR));
		busPanel = new java.awt.Panel();
		busPanel.setLayout(null);
		busPanel.setBounds(10,84,400,45);
		ethernetPanel.add(busPanel);
		busSegment1 = new kom.itbeankit.nw.ethernet.BusSegment();
		busSegment1.setLayout(null);
		busSegment1.setBounds(0,0,90,45);
		busPanel.add(busSegment1);
		busSegment2 = new kom.itbeankit.nw.ethernet.BusSegment();
		busSegment2.setLayout(null);
		busSegment2.setBounds(90,0,90,45);
		busPanel.add(busSegment2);
		busSegment3 = new kom.itbeankit.nw.ethernet.BusSegment();
		busSegment3.setLayout(null);
		busSegment3.setBounds(180,0,90,45);
		busPanel.add(busSegment3);
		busSegment4 = new kom.itbeankit.nw.ethernet.BusSegment();
		busSegment4.setLayout(null);
		busSegment4.setBounds(270,0,90,45);
		busPanel.add(busSegment4);
		hostBottomPanel = new java.awt.Panel();
		hostBottomPanel.setLayout(null);
		hostBottomPanel.setBounds(10,129,400,74);
		ethernetPanel.add(hostBottomPanel);
		host2 = new kom.itbeankit.nw.ethernet.Host();
		host2.setOverTheBus(false);
		host2.setID(2);
		host2.setLayout(null);
		host2.setBounds(25,0,80,74);
		hostBottomPanel.add(host2);
		host2.setCursor(new Cursor(Cursor.HAND_CURSOR));
		host4 = new kom.itbeankit.nw.ethernet.Host();
		host4.setOverTheBus(false);
		host4.setID(4);
		host4.setLayout(null);
		host4.setBounds(115,0,80,74);
		hostBottomPanel.add(host4);
		host4.setCursor(new Cursor(Cursor.HAND_CURSOR));
		host6 = new kom.itbeankit.nw.ethernet.Host();
		host6.setOverTheBus(false);
		host6.setID(6);
		host6.setLayout(null);
		host6.setBounds(205,0,80,74);
		hostBottomPanel.add(host6);
		host6.setCursor(new Cursor(Cursor.HAND_CURSOR));
		host8 = new kom.itbeankit.nw.ethernet.Host();
		host8.setOverTheBus(false);
		host8.setID(8);
		host8.setLayout(null);
		host8.setBounds(295,0,80,74);
		hostBottomPanel.add(host8);
		host8.setCursor(new Cursor(Cursor.HAND_CURSOR));
		efficiencyPanel = new symantec.itools.awt.BorderPanel();
		try {
			efficiencyPanel.setLabel("Efficiency");
		}
		catch(java.beans.PropertyVetoException e) { }
		GridBagLayout gridBagLayout;
		gridBagLayout = new GridBagLayout();
		efficiencyPanel.setLayout(gridBagLayout);
		efficiencyPanel.setBounds(420,31,80,209);
		add("East", efficiencyPanel);
		performanceSlider = new symantec.itools.awt.VerticalSlider();
		try {
			performanceSlider.setMaxValue(100);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			performanceSlider.setMinValue(0);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			performanceSlider.setValue(100);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			performanceSlider.setTickFreq(10);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			performanceSlider.setTickStyle(symantec.itools.awt.VerticalSlider.TICK_BOTTOM);
		}
		catch(java.beans.PropertyVetoException e) { }
		performanceSlider.setBounds(5,0,20,165);
		performanceSlider.setBackground(new Color(12632256));
		GridBagConstraints gbc;
		gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.gridheight = 3;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(0,5,-20,0);
		gbc.ipadx = 12;
		((GridBagLayout)efficiencyPanel.getLayout()).setConstraints(performanceSlider, gbc);
		efficiencyPanel.add(performanceSlider);
		performanceSlider.setEnabled(false);
		maxLabel = new java.awt.Label("100%",Label.RIGHT);
		maxLabel.setBounds(25,0,34,23);
		gbc = new GridBagConstraints();
		gbc.gridx = 1;
		gbc.gridy = 0;
		gbc.weightx = 1.0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.insets = new Insets(0,0,0,0);
		((GridBagLayout)efficiencyPanel.getLayout()).setConstraints(maxLabel, gbc);
		efficiencyPanel.add(maxLabel);
		minLabel = new java.awt.Label("0%",Label.RIGHT);
		minLabel.setBounds(35,145,24,23);
		gbc = new GridBagConstraints();
		gbc.gridx = 1;
		gbc.gridy = 3;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.insets = new Insets(0,10,0,0);
		((GridBagLayout)efficiencyPanel.getLayout()).setConstraints(minLabel, gbc);
		efficiencyPanel.add(minLabel);
		helpButton = new java.awt.Button();
		helpButton.setLabel("?");
		helpButton.setBounds(36,72,21,23);
		helpButton.setFont(new Font("Dialog", Font.BOLD, 12));
		helpButton.setForeground(new Color(255));
		helpButton.setBackground(new Color(12632256));
		gbc = new GridBagConstraints();
		gbc.gridx = 1;
		gbc.gridy = 2;
		gbc.fill = GridBagConstraints.NONE;
		gbc.insets = new Insets(0,10,0,0);
		((GridBagLayout)efficiencyPanel.getLayout()).setConstraints(helpButton, gbc);
		efficiencyPanel.add(helpButton);
		helpButton.setCursor(new Cursor(Cursor.HAND_CURSOR));
		//}}

		try {
			efficiencyPanel.setLabel(EthernetTexts.EFFICIENCY_LABEL);
		}
		catch(java.beans.PropertyVetoException e) { }

	    setAlgorithm("kom.itbeankit.nw.ethernet.OnePersistentAlgorithm");
        setNumOfHosts(8);
		//{{REGISTER_LISTENERS
		SymData lSymData = new SymData();
		busSegment1.addDataListener(lSymData);
		busSegment2.addDataListener(lSymData);
		busSegment3.addDataListener(lSymData);
		busSegment4.addDataListener(lSymData);
		host1.addDataListener(lSymData);
		host2.addDataListener(lSymData);
		host3.addDataListener(lSymData);
		host5.addDataListener(lSymData);
		host7.addDataListener(lSymData);
		host4.addDataListener(lSymData);
		host6.addDataListener(lSymData);
		host8.addDataListener(lSymData);
		SymMessage lSymMessage = new SymMessage();
		host1.addMessageListener(lSymMessage);
		host2.addMessageListener(lSymMessage);
		host3.addMessageListener(lSymMessage);
		host4.addMessageListener(lSymMessage);
		host5.addMessageListener(lSymMessage);
		host6.addMessageListener(lSymMessage);
		host7.addMessageListener(lSymMessage);
		host8.addMessageListener(lSymMessage);
		SymAction lSymAction = new SymAction();
		helpButton.addActionListener(lSymAction);
		//}}
	}
	//{{DECLARE_CONTROLS
	java.awt.Label csmaLabel;
	java.awt.Panel ethernetPanel;
	java.awt.Panel hostTopPanel;
	kom.itbeankit.nw.ethernet.Host host1;
	kom.itbeankit.nw.ethernet.Host host3;
	kom.itbeankit.nw.ethernet.Host host5;
	kom.itbeankit.nw.ethernet.Host host7;
	java.awt.Panel busPanel;
	kom.itbeankit.nw.ethernet.BusSegment busSegment1;
	kom.itbeankit.nw.ethernet.BusSegment busSegment2;
	kom.itbeankit.nw.ethernet.BusSegment busSegment3;
	kom.itbeankit.nw.ethernet.BusSegment busSegment4;
	java.awt.Panel hostBottomPanel;
	kom.itbeankit.nw.ethernet.Host host2;
	kom.itbeankit.nw.ethernet.Host host4;
	kom.itbeankit.nw.ethernet.Host host6;
	kom.itbeankit.nw.ethernet.Host host8;
	symantec.itools.awt.BorderPanel efficiencyPanel;
	symantec.itools.awt.VerticalSlider performanceSlider;
	java.awt.Label maxLabel;
	java.awt.Label minLabel;
	java.awt.Button helpButton;
	//}}

	/*public void paint(Graphics g){
	    super.paint(g);
        //setSize(getPreferredSize());
	    bus.setSize(ethernetPanel.getSize().width,30);
	    //panel.invalidate();
	}*/

    //Clock Functions
    public void clkReceived(ClkEvent e){
        doScenario(e);
    }
    //Clock Functions End

    public void reset(){
        busSegment1.reset();
        busSegment2.reset();
        busSegment3.reset();
        busSegment4.reset();
        host1.reset();
        host2.reset();
        host3.reset();
        host4.reset();
        host5.reset();
        host6.reset();
        host7.reset();
        host8.reset();

        clkReceived(new ClkEvent(this,true));
        clkReceived(new ClkEvent(this,false));
        clkReceived(new ClkEvent(this,true));
    }

    public void resetDataSize(){
		try {
			performanceSlider.setValue(100);
		}
		catch(java.beans.PropertyVetoException e) { }
        host1.resetDataSize();
        host2.resetDataSize();
        host3.resetDataSize();
        host4.resetDataSize();
        host5.resetDataSize();
        host6.resetDataSize();
        host7.resetDataSize();
        host8.resetDataSize();
    }

    public int getEfficiency(){
        double sentDataSize = 0.0;
        double receivedDataSize = 0.0;
        sentDataSize =  host1.getSentDataSize()+
                        host2.getSentDataSize()+
                        host3.getSentDataSize()+
                        host4.getSentDataSize()+
                        host5.getSentDataSize()+
                        host6.getSentDataSize()+
                        host7.getSentDataSize()+
                        host8.getSentDataSize();

        receivedDataSize =  host1.getReceivedDataSize()+
                            host2.getReceivedDataSize()+
                            host3.getReceivedDataSize()+
                            host4.getReceivedDataSize()+
                            host5.getReceivedDataSize()+
                            host6.getReceivedDataSize()+
                            host7.getReceivedDataSize()+
                            host8.getReceivedDataSize();
        double returnValue = -1;
        if(sentDataSize != 0)
            returnValue = (receivedDataSize/sentDataSize)*100;
        return (int)returnValue;
    }

    void showEfficiency(){
        int eff = getEfficiency();
        if(eff!=-1){
            try{
                performanceSlider.setValue(100-eff);
            }
            catch(Exception e){}
        }
    }

	static public void main(String args[])
	{
		class DriverFrame extends java.awt.Frame {
			public DriverFrame() {
				addWindowListener(new java.awt.event.WindowAdapter() {
					public void windowClosing(java.awt.event.WindowEvent event)
					{
						dispose();	  // free the system resources
						System.exit(0); // close the application
					}
				});
				this.setLayout(new java.awt.BorderLayout());
				this.setSize(510,205);
				this.add(new Ethernet());
				repaint();
			}
		}

		new DriverFrame().show();
	}



	class SymData implements kom.itbeankit.nw.ethernet.DataListener
	{
		public void dataToRight(kom.itbeankit.nw.ethernet.DataEvent event)
		{
			Object object = event.getSource();
			if (object == busSegment1)
				busSegment1_dataToRight(event);
			else if (object == busSegment2)
				busSegment2_dataToRight(event);
			else if (object == busSegment3)
				busSegment3_dataToRight(event);
		}

		public void dataToTop(kom.itbeankit.nw.ethernet.DataEvent event)
		{
			Object object = event.getSource();
			if (object == busSegment1)
				busSegment1_dataToTop(event);
			else if (object == busSegment2)
				busSegment2_dataToTop(event);
			else if (object == busSegment3)
				busSegment3_dataToTop(event);
			else if (object == busSegment4)
				busSegment4_dataToTop(event);
			else if (object == host2)
				host2_dataToTop(event);
			else if (object == host4)
				host4_dataToTop(event);
			else if (object == host6)
				host6_dataToTop(event);
			else if (object == host8)
				host8_dataToTop(event);
		}

		public void dataToBottom(kom.itbeankit.nw.ethernet.DataEvent event)
		{
			Object object = event.getSource();
			if (object == busSegment1)
				busSegment1_dataToBottom(event);
			else if (object == busSegment2)
				busSegment2_dataToBottom(event);
			else if (object == busSegment3)
				busSegment3_dataToBottom(event);
			else if (object == busSegment4)
				busSegment4_dataToBottom(event);
			else if (object == host1)
				host1_dataToBottom(event);
			else if (object == host3)
				host3_dataToBottom(event);
			else if (object == host5)
				host5_dataToBottom(event);
			else if (object == host7)
				host7_dataToBottom(event);
		}

		public void dataToLeft(kom.itbeankit.nw.ethernet.DataEvent event)
		{
			Object object = event.getSource();
			if (object == busSegment4)
				busSegment4_dataToLeft(event);
			else if (object == busSegment3)
				busSegment3_dataToLeft(event);
			else if (object == busSegment2)
				busSegment2_dataToLeft(event);
		}
	}

	void busSegment1_dataToRight(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromLeft...
		{
			busSegment2.dataFromLeft(event);
		}
		//}}
	}

	void busSegment2_dataToRight(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromLeft...
		{
			busSegment3.dataFromLeft(event);
		}
		//}}
	}

	void busSegment3_dataToRight(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromLeft...
		{
			busSegment4.dataFromLeft(event);
		}
		//}}
	}

	void busSegment4_dataToLeft(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromRight...
		{
			busSegment3.dataFromRight(event);
		}
		//}}
	}

	void busSegment3_dataToLeft(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromRight...
		{
			busSegment2.dataFromRight(event);
		}
		//}}
	}

	void busSegment2_dataToLeft(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromRight...
		{
			busSegment1.dataFromRight(event);
		}
		//}}
	}

	void busSegment1_dataToTop(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromBottom...
		{
			host1.dataFromBottom(event);
		}
		//}}
	}

	void busSegment1_dataToBottom(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromTop...
		{
			host2.dataFromTop(event);
		}
		//}}
	}

	void busSegment2_dataToTop(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromBottom...
		{
			host3.dataFromBottom(event);
		}
		//}}
	}

	void busSegment2_dataToBottom(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromTop...
		{
			host4.dataFromTop(event);
		}
		//}}
	}

	void busSegment3_dataToTop(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromBottom...
		{
			host5.dataFromBottom(event);
		}
		//}}
	}

	void busSegment3_dataToBottom(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromTop...
		{
			host6.dataFromTop(event);
		}
		//}}
	}

	void busSegment4_dataToTop(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromBottom...
		{
			host7.dataFromBottom(event);
		}
		//}}
	}

	void busSegment4_dataToBottom(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromTop...
		{
			host8.dataFromTop(event);
		}
		//}}
	}

	void host1_dataToBottom(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromTop...
		{
			busSegment1.dataFromTop(event);
		}
		//}}
	}

	void host2_dataToTop(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromBottom...
		{
			busSegment1.dataFromBottom(event);
		}
		//}}
	}

	void host3_dataToBottom(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromTop...
		{
			busSegment2.dataFromTop(event);
		}
		//}}
	}

	void host5_dataToBottom(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromTop...
		{
			busSegment3.dataFromTop(event);
		}
		//}}
	}

	void host7_dataToBottom(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromTop...
		{
			busSegment4.dataFromTop(event);
		}
		//}}
	}

	void host4_dataToTop(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromBottom...
		{
			busSegment2.dataFromBottom(event);
		}
		//}}
	}

	void host6_dataToTop(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromBottom...
		{
			busSegment3.dataFromBottom(event);
		}
		//}}
	}

	void host8_dataToTop(kom.itbeankit.nw.ethernet.DataEvent event)
	{
		// to do: code goes here.

		//{{CONNECTION
		// dataFromBottom...
		{
			busSegment4.dataFromBottom(event);
		}
		//}}
	}




	class SymMessage implements kom.itbeankit.common.message.MessageListener
	{
		public void deliverMessage(kom.itbeankit.common.message.MessageEvent event)
		{
				host_deliverMessage(event);
		}
	}

	void host_deliverMessage(kom.itbeankit.common.message.MessageEvent event)
	{
		deliverMessage(event);
	}

	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == helpButton)
				helpButton_ActionPerformed(event);
		}
	}

	void helpButton_ActionPerformed(java.awt.event.ActionEvent event)
	{
		deliverMessage(new MessageEvent(this, 
		                                MessageEvent.DISPLAY_TYPE_DIALOG,
		                                MessageEvent.MSG_TYPE_INFO,
		                                EthernetTexts.EFFICIENCY_LABEL,
		                                EthernetTexts.EFFICIENCY_HELP));
	}
}